<?php
/*
Plugin Name: SEO Title Tag
Plugin URI: http://www.stephanspencer.com
Description: Search engine optimize your blog's title tags. Create a customized title tag for any post, static page, category page, UltimateTagWarrior tag page - indeed, any URL! And will auto-insert the tag name into the title on tag pages generated by UltimateTagWarrior plugin. Admin allows for mass editing of title tags.
Author: Stephan Spencer
Version: 3.4.4
Author URI: http://www.stephanspencer.com

Copyright (c) 2006,2007 Stephan Spencer (http://www.stephanspencer.com)
SEO Title Tag is released under the GNU General Public
License (GPL) http://www.gnu.org/licenses/gpl.txt

This is a WordPress plugin (http://wordpress.org).

Todo:
- support meta descriptions?
- import titles by uploading a file in CSV format
- possibly rename custom option fields and table name
*/

function seo_title_tag_version_compare($test_version)
{
    $wp_version = get_bloginfo('version');
    return version_compare($test_version, $wp_version);
}

if (0 < seo_title_tag_version_compare('2.3')) {
    die('SEO Title Tags Requires WordPress 2.3 or later');
} elseif (0 < seo_title_tag_version_compare('2.5')) {
    require_once 'seo-title-tag-2.3.php';
} else {
    require_once 'seo-title-tag-3.4.php';
    register_activation_hook( __FILE__, 'seo_title_tag_install');
}

//register_deactivation_hook( __FILE__, 'remove_comment_blog_info' );
